%
%   Book: MATLAB-Based Electromagnetics (Pearson Prentice Hall)
%   Author: Branislav M. Notaros
%   Instructor Resources
%   (c) 2011
%
%   This MATLAB code or any part of it may be used only for 
%   educational purposes associated with the book
%
%
%

% Permittivity tensor of an anisotropic medium
% This program calculates electric flux density vector for the given
% electric field intensity vector and permittivity tensor of an anisotropic
% dielectric

clear all;
close all;
EPS0 = 8.8542*10^(-12);

E = [1,1,1];
Emag = sqrt(E(1)^2 + E(2)^2 + E(3)^2);

% Permittivity tensor of an anisotropic medium
EPSR = zeros(3,3);
EPSR (1,1) = 2.51;
EPSR (2,2) = 2.99;
EPSR (3,3) = 4.11;

D = EPS0.*EPSR*E';
Dmag = sqrt(D(1)^2 + D(2)^2 + D(3)^2);

disp(D);

Enorm = E./Emag;  % normalized E
Dnorm = D./Dmag;  % normalized D

figure(1)
quiver3(0,0,0,Enorm(1),Enorm(2),Enorm(3),0,'g','LineWidth',2); hold on;
text(Enorm(1)-0.01,Enorm(2)-0.01,Enorm(3)-0.01,' normalized E');
quiver3(0,0,0,Dnorm(1),Dnorm(2),Dnorm(3),0,'r','LineWidth',2);
text(Dnorm(1)-0.01,Dnorm(2)-0.01,Dnorm(3)-0.01,' normalized D');hold off;
xlabel('x');
ylabel('y');
zlabel('z');

